<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->json('title')->nullable();
			$table->json('body')->nullable();
			$table->integer('user_id')->unsigned();
			$table->enum('type', array('admin', 'order', 'payment', 'product'))->nullable();
			$table->enum('seen', array('true', 'false'))->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}