<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('device_tokens', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('families', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('drivers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('views', function(Blueprint $table) {
			$table->foreign('visitor_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('views', function(Blueprint $table) {
			$table->foreign('family_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('family_categories', function(Blueprint $table) {
			$table->foreign('family_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('family_categories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('followers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('followers', function(Blueprint $table) {
			$table->foreign('family_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('driver_categories', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('driver_categories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('family_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('product_images', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('family_rates', function(Blueprint $table) {
			$table->foreign('family_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('family_rates', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('family_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('family_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('addresses')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('order_cancels', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('order_cancels', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('order_carts', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('order_carts', function(Blueprint $table) {
			$table->foreign('cart_id')->references('id')->on('carts')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('driver_rates', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('driver_rates', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('vacation_days', function(Blueprint $table) {
			$table->foreign('family_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('device_tokens', function(Blueprint $table) {
			$table->dropForeign('device_tokens_user_id_foreign');
		});
		Schema::table('families', function(Blueprint $table) {
			$table->dropForeign('families_user_id_foreign');
		});
		Schema::table('drivers', function(Blueprint $table) {
			$table->dropForeign('drivers_user_id_foreign');
		});
		Schema::table('views', function(Blueprint $table) {
			$table->dropForeign('views_visitor_id_foreign');
		});
		Schema::table('views', function(Blueprint $table) {
			$table->dropForeign('views_family_id_foreign');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->dropForeign('favorites_user_id_foreign');
		});
		Schema::table('family_categories', function(Blueprint $table) {
			$table->dropForeign('family_categories_family_id_foreign');
		});
		Schema::table('family_categories', function(Blueprint $table) {
			$table->dropForeign('family_categories_category_id_foreign');
		});
		Schema::table('followers', function(Blueprint $table) {
			$table->dropForeign('followers_user_id_foreign');
		});
		Schema::table('followers', function(Blueprint $table) {
			$table->dropForeign('followers_family_id_foreign');
		});
		Schema::table('driver_categories', function(Blueprint $table) {
			$table->dropForeign('driver_categories_driver_id_foreign');
		});
		Schema::table('driver_categories', function(Blueprint $table) {
			$table->dropForeign('driver_categories_category_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_family_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_category_id_foreign');
		});
		Schema::table('product_images', function(Blueprint $table) {
			$table->dropForeign('product_images_product_id_foreign');
		});
		Schema::table('family_rates', function(Blueprint $table) {
			$table->dropForeign('family_rates_family_id_foreign');
		});
		Schema::table('family_rates', function(Blueprint $table) {
			$table->dropForeign('family_rates_user_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_user_id_foreign');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_user_id_foreign');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_user_id_foreign');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_family_id_foreign');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_product_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_family_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_driver_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_address_id_foreign');
		});
		Schema::table('order_cancels', function(Blueprint $table) {
			$table->dropForeign('order_cancels_order_id_foreign');
		});
		Schema::table('order_cancels', function(Blueprint $table) {
			$table->dropForeign('order_cancels_user_id_foreign');
		});
		Schema::table('order_carts', function(Blueprint $table) {
			$table->dropForeign('order_carts_order_id_foreign');
		});
		Schema::table('order_carts', function(Blueprint $table) {
			$table->dropForeign('order_carts_cart_id_foreign');
		});
		Schema::table('driver_rates', function(Blueprint $table) {
			$table->dropForeign('driver_rates_user_id_foreign');
		});
		Schema::table('driver_rates', function(Blueprint $table) {
			$table->dropForeign('driver_rates_driver_id_foreign');
		});
		Schema::table('vacation_days', function(Blueprint $table) {
			$table->dropForeign('vacation_days_family_id_foreign');
		});
	}
}