<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('quantity');
			$table->string('name', 255);
			$table->text('notes');
			$table->string('address', 255);
			$table->decimal('cost');
			$table->decimal('total');
			$table->decimal('delivery_cost');
			$table->string('special_order');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}