<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;
    protected $fillable = array('quantity', 'name', 'notes', 'address', 'cost', 'total', 'delivery_cost', 'special_order');

    public function resturant()
    {
        return $this->belongsTo('App\Resturant');
    }

    public function client()
    {
        return $this->belongsTo('App\Client');
    }

    public function products()
    {
        return $this->belongsToMany('App\Product');
    }

    public function payment_method()
    {
        return $this->belongsTo('App\Product');
    }

}