<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAnnualActivationPriceTable extends Migration {

	public function up()
	{
		Schema::create('annual_activation_price', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255)->nullable();
			$table->float('price')->nullable();
			$table->integer('role_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('annual_activation_price');
	}
}