<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntitiesTable extends Migration {

	public function up()
	{
		Schema::create('entities', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('ar_name', 255)->nullable();
			$table->string('en_name', 255)->nullable();
			$table->string('ar_address', 500)->nullable();
			$table->string('en_address', 255)->nullable();
			$table->string('tax_registration_number', 255)->nullable();
			$table->string('commercial_registration_number', 255)->nullable();
			$table->string('joining_purpose', 255)->nullable();
			$table->string('phone_number', 255)->nullable();
			$table->string('ar_representative_department', 255)->nullable();
			$table->string('en_representative_department', 255)->nullable();
			$table->string('ar_representative_division', 255)->nullable();
			$table->string('en_representative_division', 255)->nullable();
			$table->string('notes', 500)->nullable();
			$table->integer('request_status')->nullable();
			$table->integer('request_code')->nullable();
			$table->timestamp('end_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('entities');
	}
}