<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntityActionsTable extends Migration {

	public function up()
	{
		Schema::create('entity_actions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('action')->nullable();
			$table->string('notes', 500)->nullable();
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('entity_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('entity_actions');
	}
}