<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntityAdditionsTable extends Migration {

	public function up()
	{
		Schema::create('entity_additions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('addition_id')->unsigned()->nullable();
			$table->integer('entity_package_id')->unsigned()->nullable();
			$table->bigInteger('purchased_quota')->nullable();
			$table->bigInteger('available_quota')->nullable();
			$table->float('price')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('entity_additions');
	}
}