<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePackageLogsTable extends Migration {

	public function up()
	{
		Schema::create('package_logs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('package_id')->unsigned()->nullable();
			$table->string('name', 255)->nullable();
			$table->integer('duration')->nullable();
			$table->bigInteger('quota')->nullable();
			$table->float('price')->nullable();
			$table->integer('status')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('package_logs');
	}
}