<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('ar_name', 255);
			$table->string('en_name', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->timestamp('email_verified_at')->nullable();
			$table->string('password', 255)->nullable();
			$table->string('remember_token', 500)->nullable();
			$table->string('last_token', 500)->nullable();
			$table->integer('role_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}