<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('entity_actions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_actions', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_additions', function(Blueprint $table) {
			$table->foreign('addition_id')->references('id')->on('additions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_additions', function(Blueprint $table) {
			$table->foreign('entity_package_id')->references('id')->on('entity_package')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_package', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('package')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_package', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('package', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('package_logs', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('package')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_passwords', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('attachment', function(Blueprint $table) {
			$table->foreign('attachment_id')->references('id')->on('attachment')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_activations', function(Blueprint $table) {
			$table->foreign('payment_transaction_id')->references('id')->on('payment_transactions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_activations', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_activations', function(Blueprint $table) {
			$table->foreign('activation_id')->references('id')->on('annual_activation_price')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('annual_activation_price', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('additions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('additions_logs', function(Blueprint $table) {
			$table->foreign('addition_id')->references('id')->on('additions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('integration_logs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payment_transactions', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payment_transactions', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payment_transactions', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('package')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payment_transactions', function(Blueprint $table) {
			$table->foreign('addition_id')->references('id')->on('additions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('verified_mails', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('annual_activation_price_logs', function(Blueprint $table) {
			$table->foreign('activation_id')->references('id')->on('annual_activation_price')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('annual_activation_price_logs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_users', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branch')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('checker_reviewer', function(Blueprint $table) {
			$table->foreign('checker_id')->references('id')->on('entity_users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('checker_reviewer', function(Blueprint $table) {
			$table->foreign('reviewer_id')->references('id')->on('entity_users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('checker_requests', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_annual_logs', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payment_logs', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entity_users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payment_logs', function(Blueprint $table) {
			$table->foreign('payment_transaction_id')->references('id')->on('payment_transactions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('blocked_domain', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('checker_quota', function(Blueprint $table) {
			$table->foreign('entity_user_id')->references('id')->on('entity_users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('checker_quota', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branch')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_users_activations_logs', function(Blueprint $table) {
			$table->foreign('entity_user_id')->references('id')->on('entity_users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_users_activations_logs', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branch')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branch', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branch_activations', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branch')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branch_quota', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branch')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('entity_actions', function(Blueprint $table) {
			$table->dropForeign('entity_actions_user_id_foreign');
		});
		Schema::table('entity_actions', function(Blueprint $table) {
			$table->dropForeign('entity_actions_entity_id_foreign');
		});
		Schema::table('entity_additions', function(Blueprint $table) {
			$table->dropForeign('entity_additions_addition_id_foreign');
		});
		Schema::table('entity_additions', function(Blueprint $table) {
			$table->dropForeign('entity_additions_entity_package_id_foreign');
		});
		Schema::table('entity_package', function(Blueprint $table) {
			$table->dropForeign('entity_package_package_id_foreign');
		});
		Schema::table('entity_package', function(Blueprint $table) {
			$table->dropForeign('entity_package_entity_id_foreign');
		});
		Schema::table('package', function(Blueprint $table) {
			$table->dropForeign('package_user_id_foreign');
		});
		Schema::table('package_logs', function(Blueprint $table) {
			$table->dropForeign('package_logs_package_id_foreign');
		});
		Schema::table('user_passwords', function(Blueprint $table) {
			$table->dropForeign('user_passwords_user_id_foreign');
		});
		Schema::table('attachment', function(Blueprint $table) {
			$table->dropForeign('attachment_attachment_id_foreign');
		});
		Schema::table('entity_activations', function(Blueprint $table) {
			$table->dropForeign('entity_activations_payment_transaction_id_foreign');
		});
		Schema::table('entity_activations', function(Blueprint $table) {
			$table->dropForeign('entity_activations_entity_id_foreign');
		});
		Schema::table('entity_activations', function(Blueprint $table) {
			$table->dropForeign('entity_activations_activation_id_foreign');
		});
		Schema::table('annual_activation_price', function(Blueprint $table) {
			$table->dropForeign('annual_activation_price_role_id_foreign');
		});
		Schema::table('additions', function(Blueprint $table) {
			$table->dropForeign('additions_user_id_foreign');
		});
		Schema::table('additions_logs', function(Blueprint $table) {
			$table->dropForeign('additions_logs_addition_id_foreign');
		});
		Schema::table('integration_logs', function(Blueprint $table) {
			$table->dropForeign('integration_logs_user_id_foreign');
		});
		Schema::table('payment_transactions', function(Blueprint $table) {
			$table->dropForeign('payment_transactions_entity_id_foreign');
		});
		Schema::table('payment_transactions', function(Blueprint $table) {
			$table->dropForeign('payment_transactions_role_id_foreign');
		});
		Schema::table('payment_transactions', function(Blueprint $table) {
			$table->dropForeign('payment_transactions_package_id_foreign');
		});
		Schema::table('payment_transactions', function(Blueprint $table) {
			$table->dropForeign('payment_transactions_addition_id_foreign');
		});
		Schema::table('verified_mails', function(Blueprint $table) {
			$table->dropForeign('verified_mails_user_id_foreign');
		});
		Schema::table('annual_activation_price_logs', function(Blueprint $table) {
			$table->dropForeign('annual_activation_price_logs_activation_id_foreign');
		});
		Schema::table('annual_activation_price_logs', function(Blueprint $table) {
			$table->dropForeign('annual_activation_price_logs_user_id_foreign');
		});
		Schema::table('entity_users', function(Blueprint $table) {
			$table->dropForeign('entity_users_user_id_foreign');
		});
		Schema::table('entity_users', function(Blueprint $table) {
			$table->dropForeign('entity_users_branch_id_foreign');
		});
		Schema::table('checker_reviewer', function(Blueprint $table) {
			$table->dropForeign('checker_reviewer_checker_id_foreign');
		});
		Schema::table('checker_reviewer', function(Blueprint $table) {
			$table->dropForeign('checker_reviewer_reviewer_id_foreign');
		});
		Schema::table('checker_requests', function(Blueprint $table) {
			$table->dropForeign('checker_requests_user_id_foreign');
		});
		Schema::table('entity_annual_logs', function(Blueprint $table) {
			$table->dropForeign('entity_annual_logs_entity_id_foreign');
		});
		Schema::table('payment_logs', function(Blueprint $table) {
			$table->dropForeign('payment_logs_entity_id_foreign');
		});
		Schema::table('payment_logs', function(Blueprint $table) {
			$table->dropForeign('payment_logs_payment_transaction_id_foreign');
		});
		Schema::table('blocked_domain', function(Blueprint $table) {
			$table->dropForeign('blocked_domain_user_id_foreign');
		});
		Schema::table('checker_quota', function(Blueprint $table) {
			$table->dropForeign('checker_quota_entity_user_id_foreign');
		});
		Schema::table('checker_quota', function(Blueprint $table) {
			$table->dropForeign('checker_quota_branch_id_foreign');
		});
		Schema::table('entity_users_activations_logs', function(Blueprint $table) {
			$table->dropForeign('entity_users_activations_logs_entity_user_id_foreign');
		});
		Schema::table('entity_users_activations_logs', function(Blueprint $table) {
			$table->dropForeign('entity_users_activations_logs_branch_id_foreign');
		});
		Schema::table('branch', function(Blueprint $table) {
			$table->dropForeign('branch_entity_id_foreign');
		});
		Schema::table('branch_activations', function(Blueprint $table) {
			$table->dropForeign('branch_activations_branch_id_foreign');
		});
		Schema::table('branch_quota', function(Blueprint $table) {
			$table->dropForeign('branch_quota_branch_id_foreign');
		});
	}
}