<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 50);
			$table->string('message', 150);
			$table->datetime('time');
			$table->tinyInteger('status')->default('0');
			$table->integer('client_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}