<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 100);
			$table->string('email', 50)->unique();
			$table->date('email_verified_at')->nullable();
			$table->string('password', 50);
			$table->integer('role_id')->unsigned();
			$table->tinyInteger('is_active')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}