<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequestsTable extends Migration {

	public function up()
	{
		Schema::create('requests', function(Blueprint $table) {
			$table->increments('id', true);
			$table->integer('village_id')->unsigned()->nullable();
			$table->string('created_by');
			$table->string('type');
			$table->double('quantity')->default('0');
			$table->enum('quantity_unit', array('kg', 'liter', 'meter', 'other'));
			$table->enum('emergency', array('normal', 'medium', 'high'));
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('requests');
	}
}