<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CuisineAssigned extends Model 
{

    protected $table = 'cuisine_assigned';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('cuisine_id', 'entity_id', 'status');

    public function Cuisines()
    {
        return $this->hasOne('\Cuisines', 'cuisine_id');
    }

    public function Entities()
    {
        return $this->hasOne('\Entities', 'entity_id');
    }

}