<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Invoices extends Model 
{

    protected $table = 'invoices';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('uuid', 'entity_id', 'terms', 'period', 'total_amount', 'transaction_id', 'payment_mode_id');

    public function paymentMode()
    {
        return $this->hasOne('PaymentMode', 'payment_mode_id');
    }

    public function entity()
    {
        return $this->hasOne('Entities', 'entity_id');
    }

}