<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TagAssigned extends Model 
{

    protected $table = 'tags_assigned';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('uuid');

    public function entity()
    {
        return $this->hasOne('Entities', 'entity_id');
    }

    public function tags()
    {
        return $this->hasOne('Tags', 'tag_id');
    }

}