<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Taxes extends Model 
{

    protected $table = 'taxes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('tax_percentage', 'country_id');

    public function country()
    {
        return $this->hasOne('\Country', 'country_id');
    }

    public function taxtype()
    {
        return $this->hasOne('\TaxType', 'tax_type');
    }

}