<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->integer('payment_id')->unsigned()->nullable();
			$table->integer('entity_id')->unsigned();
			$table->integer('payment_mode_id')->unsigned();
			$table->integer('consumer_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}