<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntityRatingsTable extends Migration {

	public function up()
	{
		Schema::create('entity_ratings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned();
			$table->integer('entity_id')->unsigned()->nullable();
			$table->double('rating')->nullable();
			$table->text('comment')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('entity_ratings');
	}
}