<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStateTable extends Migration {

	public function up()
	{
		Schema::create('state', function(Blueprint $table) {
			$table->increments('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255)->nullable();
			$table->integer('country_id')->unsigned()->nullable();
			$table->uuid('uuid', 90);
		});
	}

	public function down()
	{
		Schema::drop('state');
	}
}