<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVouchersTable extends Migration {

	public function up()
	{
		Schema::create('vouchers', function(Blueprint $table) {
			$table->increments('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255)->nullable();
			$table->integer('type_id')->unsigned();
			$table->double('discount')->nullable();
			$table->datetime('start_date')->nullable();
			$table->datetime('end_date')->nullable();
			$table->integer('entity_id')->unsigned()->nullable();
			$table->tinyInteger('status')->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('vouchers');
	}
}