<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeesTable extends Migration {

	public function up()
	{
		Schema::create('employees', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('full_name', 191);
			$table->string('mobile_number');
			$table->string('tel_number', 191);
			$table->string('email', 191);
			$table->text('designation');
			$table->text('address');
			$table->integer('country_id')->unsigned();
			$table->string('branch', 191);
			$table->string('remark', 191);
			$table->string('employee', 191);
			$table->string('image', 191);
			$table->string('user_name', 191);
			$table->string('password', 191);
		});
	}

	public function down()
	{
		Schema::drop('employees');
	}
}