<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('learners', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('addresses')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('learners', function(Blueprint $table) {
			$table->foreign('living_with')->references('id')->on('living_with')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('learners', function(Blueprint $table) {
			$table->foreign('religion')->references('id')->on('religions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sections', function(Blueprint $table) {
			$table->foreign('section_name_id')->references('id')->on('section_names')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('sections', function(Blueprint $table) {
			$table->foreign('adviser_id')->references('id')->on('teachers')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('learner_section', function(Blueprint $table) {
			$table->foreign('learner_id')->references('id')->on('learners')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('learner_section', function(Blueprint $table) {
			$table->foreign('section_id')->references('id')->on('sections')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('section_subject', function(Blueprint $table) {
			$table->foreign('section_id')->references('id')->on('sections')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('section_subject', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('section_subject_teacher', function(Blueprint $table) {
			$table->foreign('section_subject_id')->references('id')->on('section_subject')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('section_subject_teacher', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('teachers')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('special_sections', function(Blueprint $table) {
			$table->foreign('section_name_id')->references('id')->on('section_names')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('special_sections', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('special_sections', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('teachers')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('learner_special_section', function(Blueprint $table) {
			$table->foreign('learner_id')->references('id')->on('learners')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('learner_special_section', function(Blueprint $table) {
			$table->foreign('special_section_id')->references('id')->on('special_sections')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('guardian_learner', function(Blueprint $table) {
			$table->foreign('guardian_id')->references('id')->on('guardians')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('guardian_learner', function(Blueprint $table) {
			$table->foreign('learner_id')->references('id')->on('learners')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('behavioral_concern_learner', function(Blueprint $table) {
			$table->foreign('behavioral_concern_id')->references('id')->on('behavioral_concerns')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('behavioral_concern_learner', function(Blueprint $table) {
			$table->foreign('learner_id')->references('id')->on('learners')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('health_concern_learner', function(Blueprint $table) {
			$table->foreign('health_concern_id')->references('id')->on('health_concerns')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('health_concern_learner', function(Blueprint $table) {
			$table->foreign('learner_id')->references('id')->on('learners')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('learners', function(Blueprint $table) {
			$table->dropForeign('learners_address_id_foreign');
		});
		Schema::table('learners', function(Blueprint $table) {
			$table->dropForeign('learners_living_with_foreign');
		});
		Schema::table('learners', function(Blueprint $table) {
			$table->dropForeign('learners_religion_foreign');
		});
		Schema::table('sections', function(Blueprint $table) {
			$table->dropForeign('sections_section_name_id_foreign');
		});
		Schema::table('sections', function(Blueprint $table) {
			$table->dropForeign('sections_adviser_id_foreign');
		});
		Schema::table('learner_section', function(Blueprint $table) {
			$table->dropForeign('learner_section_learner_id_foreign');
		});
		Schema::table('learner_section', function(Blueprint $table) {
			$table->dropForeign('learner_section_section_id_foreign');
		});
		Schema::table('section_subject', function(Blueprint $table) {
			$table->dropForeign('section_subject_section_id_foreign');
		});
		Schema::table('section_subject', function(Blueprint $table) {
			$table->dropForeign('section_subject_subject_id_foreign');
		});
		Schema::table('section_subject_teacher', function(Blueprint $table) {
			$table->dropForeign('section_subject_teacher_section_subject_id_foreign');
		});
		Schema::table('section_subject_teacher', function(Blueprint $table) {
			$table->dropForeign('section_subject_teacher_teacher_id_foreign');
		});
		Schema::table('special_sections', function(Blueprint $table) {
			$table->dropForeign('special_sections_section_name_id_foreign');
		});
		Schema::table('special_sections', function(Blueprint $table) {
			$table->dropForeign('special_sections_subject_id_foreign');
		});
		Schema::table('special_sections', function(Blueprint $table) {
			$table->dropForeign('special_sections_teacher_id_foreign');
		});
		Schema::table('learner_special_section', function(Blueprint $table) {
			$table->dropForeign('learner_special_section_learner_id_foreign');
		});
		Schema::table('learner_special_section', function(Blueprint $table) {
			$table->dropForeign('learner_special_section_special_section_id_foreign');
		});
		Schema::table('guardian_learner', function(Blueprint $table) {
			$table->dropForeign('guardian_learner_guardian_id_foreign');
		});
		Schema::table('guardian_learner', function(Blueprint $table) {
			$table->dropForeign('guardian_learner_learner_id_foreign');
		});
		Schema::table('behavioral_concern_learner', function(Blueprint $table) {
			$table->dropForeign('behavioral_concern_learner_behavioral_concern_id_foreign');
		});
		Schema::table('behavioral_concern_learner', function(Blueprint $table) {
			$table->dropForeign('behavioral_concern_learner_learner_id_foreign');
		});
		Schema::table('health_concern_learner', function(Blueprint $table) {
			$table->dropForeign('health_concern_learner_health_concern_id_foreign');
		});
		Schema::table('health_concern_learner', function(Blueprint $table) {
			$table->dropForeign('health_concern_learner_learner_id_foreign');
		});
	}
}