<?php

namespace AGrS\Models;

class Learner extends Eloquent {

	protected $table = 'learners';
	public $timestamps = false;

	public function guardians()
	{
		return $this->belongsToMany('AGrS\Models\Guardian');
	}

	public function sections()
	{
		return $this->belongsToMany('AGrS\Models\Section');
	}

	public function specialsections()
	{
		return $this->belongsToMany('AGrS\Models\SpecialSection');
	}

	public function behaviralConcerns()
	{
		return $this->belongsToMany('AGrS\Models\BehavioralConcerns');
	}

	public function healthConcerns()
	{
		return $this->belongsToMany('AGrS\Models\HealthConcern');
	}

	public function religion()
	{
		return $this->belongsTo('AGrS\Models\Religion');
	}

	public function living_with()
	{
		return $this->belongsTo('AGrS\Models\LivingWith');
	}

	public function address()
	{
		return $this->belongsTo('AGrS\Models\Address');
	}

}