<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('Users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('username', 191)->unique()->nullable();
			$table->string('email', 191)->unique();
			$table->string('password', 191);
			$table->tinyInteger('status')->default('1');
			$table->tinyInteger('created_by');
			$table->tinyInteger('updated_by');
			$table->date('dob');
			$table->string('phone', 191);
			$table->tinyInteger('gender')->default('0');
			$table->string('picture', 191);
			$table->tinyInteger('permission_id');
			$table->integer('group_user_configuration_id');
			$table->integer('school_id');
			$table->integer('province_id');
			$table->integer('district_id');
			$table->integer('ward_id');
			$table->string('adress', 191);
		});
	}

	public function down()
	{
		Schema::drop('Users');
	}
}