<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAssignedKeyInfoItemTable extends Migration {

	public function up()
	{
		Schema::create('assigned_key_info_item', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('house_id');
			$table->integer('offer_id');
			$table->integer('key_info_id');
			$table->string('key_info_name');
			$table->boolean('key_info_connected_item');
			$table->integer('key_info_customary_offer_id');
			$table->integer('key_info_order');
			$table->string('key_info_state');
			$table->longText('key_info_description');
			$table->string('key_info_typical_label');
			$table->string('key_info_typical_value');
			$table->integer('key_info_offer_category_id');
			$table->string('key_info_is_mandatory');
			$table->boolean('key_info_is_user_change');
			$table->string('key_info_user_change_text');
			$table->boolean('key_info_date_days_applicable');
			$table->string('key_info_date_days_text');
			$table->boolean('key_info_is_amount_comment');
			$table->string('key_info_is_amount_comment_text');
			$table->string('key_info_placeholder_text');
			$table->string('key_info_default_value');
			$table->string('key_info_typical_info');
			$table->string('key_info_typical_info_prev');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('assigned_key_info_item');
	}
}