<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateParentsTable extends Migration {

	public function up()
	{
		Schema::create('parents', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('mobile', 30)->unique();
			$table->string('email', 100)->unique();
			$table->string('national_id', 14)->unique();
			$table->string('address');
			$table->string('job');
			$table->enum('gender', array('male', 'female'));
			$table->date('date_birth');
			$table->string('password');
		});
	}

	public function down()
	{
		Schema::drop('parents');
	}
}