<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUnitesTable extends Migration {

	public function up()
	{
		Schema::create('unites', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('id_vin')->unsigned();
			$table->string('uid', 255)->unique();
			$table->integer('id_entree_stock')->unsigned()->nullable();
			$table->enum('statut', array('enstock', 'vendu', 'perdu'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('unites');
	}
}