<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Prix extends Eloquent {

	protected $table = 'prix';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('id_vin', 'montant', 'quantite', 'taille', 'volume', 'description', 'image');
	protected $visible = array('id_vin', 'montant', 'quantite', 'taille', 'volume', 'description', 'image');

	public function vin()
	{
		return $this->belongsTo('App\Models\Vin', 'id_vin');
	}

	public function lignes_ventes()
	{
		return $this->hasMany('App\Models\Ligne_vente', 'id_prix');
	}

}