<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Unite extends Eloquent {

	protected $table = 'unites';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('id_vin', 'uid', 'id_entree_stock');
	protected $visible = array('id_vin', 'uid', 'id_entree_stock');

	public function vin()
	{
		return $this->belongsTo('App\Models\Vin', 'id_vin');
	}

	public function entree_stock()
	{
		return $this->belongsTo('App\Models\Entree_stock', 'id_entree_stock');
	}

}