<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffersTable extends Migration {

	public function up()
	{
		Schema::create('offers', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('collective', 'particular', 'individual_digital', 'digital'));
			$table->integer('price');
			$table->integer('duration');
			$table->bigInteger('coach_id')->unsigned()->index();
			$table->text('description');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('offers');
	}
}