<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSlotsTable extends Migration {

	public function up()
	{
		Schema::create('slots', function(Blueprint $table) {
			$table->increments('id');
			$table->datetime('start_date');
			$table->datetime('end_date');
			$table->bigInteger('coach_id')->unsigned()->index();
			$table->bigInteger('agenda_id')->unsigned()->index();
			$table->smallInteger('participants');
			$table->bigInteger('recurence_id')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('slots');
	}
}