<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Coach extends Model 
{

    protected $table = 'coaches';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function golfAttributes()
    {
        return $this->morphOne('GolfAttribute', 'model');
    }

    public function languages()
    {
        return $this->morphMany('Language', 'languageable');
    }

    public function specialties()
    {
        return $this->morphMany('Specialty', 'specializables')->withPivot('self_evaluation');
    }

    public function country()
    {
        return $this->belongsTo('Country');
    }

    public function city()
    {
        return $this->belongsTo('City');
    }

    public function offers()
    {
        return $this->hasMany('Offer');
    }

    public function address()
    {
        return $this->morphOne('Address', 'model');
    }

    public function agenda()
    {
        return $this->hasOne('Agenda');
    }

    public function promoCodes()
    {
        return $this->hasMany('PromoCode');
    }

    public function notifiationSettings()
    {
        return $this->morphMany('NotificationSettings');
    }

}