<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Slot extends Model 
{

    protected $table = 'slots';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function offers()
    {
        return $this->belongsToMany('Offer', 'slot_offer');
    }

    public function golfClub()
    {
        return $this->belongsTo('GolfClub');
    }

    public function recurrence()
    {
        return $this->belongsTo('Recurrence');
    }

}