<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Attachment extends Eloquent {

	protected $table = 'attachments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function users()
	{
		return $this->morphedByMany('User', 'attachmentable');
	}

	public function specializations()
	{
		return $this->morphedByMany('Specialization', 'attachmentable');
	}

}