<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Role extends Eloquent {

	protected $table = 'roles';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function users()
	{
		return $this->hasMany('User', 'role_id', 'id');
	}

	public function permissions()
	{
		return $this->belongsToMany('Permission');
	}

}