<?php

namespace app/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Businessowner extends Eloquent {

	protected $table = 'businessowners';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'email');

	public function havebusinessactivity()
	{
		return $this->hasMany('Businessactivity', 'businessowner_id');
	}

}