<?php

namespace app/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Offer extends Eloquent {

	protected $table = 'offer';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function media()
	{
		return $this->hasMany('OfferMedia', 'offer_id');
	}

	public function keyword()
	{
		return $this->hasMany('Keyword', 'offer_id');
	}

	public function offeritme()
	{
		return $this->hasMany('Offer_items', 'offer_id');
	}

	public function rate()
	{
		return $this->hasMany('Offerratio', 'offer_id');
	}

	public function hasview()
	{
		return $this->hasMany('Offerview');
	}

}