<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Resevation extends Model 
{

    protected $table = 'Reservations';
    public $timestamps = true;

    public function site()
    {
        return $this->belongsTo('Site');
    }

    public function client()
    {
        return $this->belongsTo('User');
    }

    public function products()
    {
        return $this->belongsToMany('Product')->withPivot('reservation_products');
    }

    public function period()
    {
        return $this->belongsTo('Period', 'period_id');
    }

}