<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Photos', function(Blueprint $table) {
			$table->foreign('site_id')->references('id')->on('Sites')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Reservations', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Reservations', function(Blueprint $table) {
			$table->foreign('site_id')->references('id')->on('Sites')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Reservations', function(Blueprint $table) {
			$table->foreign('period_id')->references('id')->on('Periods')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Site_period_prices', function(Blueprint $table) {
			$table->foreign('site_id')->references('id')->on('Sites')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Site_period_prices', function(Blueprint $table) {
			$table->foreign('period_id')->references('id')->on('Periods')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Product_period_prices', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('Periods')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Product_period_prices', function(Blueprint $table) {
			$table->foreign('period_id')->references('id')->on('Periods')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Reservation_products', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('Products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Reservation_products', function(Blueprint $table) {
			$table->foreign('reservation_id')->references('id')->on('Reservations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('Photos', function(Blueprint $table) {
			$table->dropForeign('Photos_site_id_foreign');
		});
		Schema::table('Reservations', function(Blueprint $table) {
			$table->dropForeign('Reservations_client_id_foreign');
		});
		Schema::table('Reservations', function(Blueprint $table) {
			$table->dropForeign('Reservations_site_id_foreign');
		});
		Schema::table('Reservations', function(Blueprint $table) {
			$table->dropForeign('Reservations_period_id_foreign');
		});
		Schema::table('Site_period_prices', function(Blueprint $table) {
			$table->dropForeign('Site_period_prices_site_id_foreign');
		});
		Schema::table('Site_period_prices', function(Blueprint $table) {
			$table->dropForeign('Site_period_prices_period_id_foreign');
		});
		Schema::table('Product_period_prices', function(Blueprint $table) {
			$table->dropForeign('Product_period_prices_product_id_foreign');
		});
		Schema::table('Product_period_prices', function(Blueprint $table) {
			$table->dropForeign('Product_period_prices_period_id_foreign');
		});
		Schema::table('Reservation_products', function(Blueprint $table) {
			$table->dropForeign('Reservation_products_product_id_foreign');
		});
		Schema::table('Reservation_products', function(Blueprint $table) {
			$table->dropForeign('Reservation_products_reservation_id_foreign');
		});
	}
}