<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function profile()
    {
        return $this->hasOne('UserProfile');
    }

    public function views()
    {
        return $this->belongsToMany('NewsView');
    }

    public function comments()
    {
        return $this->hasMany('NewsComment');
    }

    public function news()
    {
        return $this->hasMany('News');
    }

}