<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Game extends Model 
{

    protected $table = 'app_game';
    public $timestamps = false;

    public function getRule()
    {
        return $this->hasOne('Rule');
    }

    public function owner()
    {
        return $this->hasOne('User');
    }

    public function opponent()
    {
        return $this->hasOne('User');
    }

    public function ownerdeck()
    {
        return $this->hasOne('Deck');
    }

    public function opponentDeck()
    {
        return $this->hasOne('Deck');
    }

    public function playerdeck()
    {
        return $this->hasOne('User');
    }

    public function ownerdeck_cards()
    {
        return $this->belongsToMany('OwnerDeckCards');
    }

    public function opponent_deck_cards()
    {
        return $this->belongsToMany('OpponentDeckCards');
    }

    public function owner_hand_cards()
    {
        return $this->belongsToMany('OwnerHandCards');
    }

    public function opponent_hand_cards()
    {
        return $this->belongsToMany('OpponentHandCards');
    }

    public function owner_board_card_values()
    {
        return $this->belongsToMany('OwnerBoardValues');
    }

    public function opponent_board_card_values()
    {
        return $this->belongsToMany('OpponentBoardCardValues');
    }

    public function owner_graveyard_cards()
    {
        return $this->belongsToMany('OwnerGraveyardCards');
    }

    public function opponent_graveyard_cards()
    {
        return $this->hasOne('OpponentGraveyardCards');
    }

}