<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppGameTable extends Migration {

	public function up()
	{
		Schema::create('app_game', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('turn');
			$table->integer('owner_mana');
			$table->integer('opponent_mana');
			$table->integer('opponent_health');
			$table->integer('owner_health');
			$table->integer('opponent_id')->unsigned();
			$table->integer('opponent_deck_id')->unsigned();
			$table->integer('owner_id')->unsigned();
			$table->integer('owner_deck_id')->unsigned();
			$table->integer('player_turn_id')->unsigned();
			$table->integer('rule_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('app_game');
	}
}