<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('app_card', function(Blueprint $table) {
			$table->foreign('effect_id')->references('id')->on('app_card_effect')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_card_value', function(Blueprint $table) {
			$table->foreign('card_id')->references('id')->on('app_card')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_card_value', function(Blueprint $table) {
			$table->foreign('user')->references('id')->on('app_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_deck', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('app_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_deck_cards', function(Blueprint $table) {
			$table->foreign('deck_id')->references('id')->on('app_deck')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_deck_cards', function(Blueprint $table) {
			$table->foreign('card_id')->references('id')->on('app_card')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game', function(Blueprint $table) {
			$table->foreign('opponent_id')->references('id')->on('app_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game', function(Blueprint $table) {
			$table->foreign('opponent_deck_id')->references('id')->on('app_deck')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game', function(Blueprint $table) {
			$table->foreign('owner_id')->references('id')->on('app_deck')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game', function(Blueprint $table) {
			$table->foreign('owner_deck_id')->references('id')->on('app_deck')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game', function(Blueprint $table) {
			$table->foreign('player_turn_id')->references('id')->on('app_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game', function(Blueprint $table) {
			$table->foreign('rule_id')->references('id')->on('app_rule')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game_log', function(Blueprint $table) {
			$table->foreign('game_id')->references('id')->on('app_game')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game_log', function(Blueprint $table) {
			$table->foreign('looser_id')->references('id')->on('app_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game_log', function(Blueprint $table) {
			$table->foreign('winner_id')->references('id')->on('app_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game_log_action', function(Blueprint $table) {
			$table->foreign('game_log_id')->references('id')->on('app_game_log')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game_log_action', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('app_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game_opponnent_board_card_values', function(Blueprint $table) {
			$table->foreign('game_id')->references('id')->on('app_game')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game_opponnent_board_card_values', function(Blueprint $table) {
			$table->foreign('cardvalue_id')->references('id')->on('app_card')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game_opponent_deck_cards', function(Blueprint $table) {
			$table->foreign('game_id')->references('id')->on('app_game')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game_opponent_deck_cards', function(Blueprint $table) {
			$table->foreign('card_id')->references('id')->on('app_card')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game_opponent_graveyard_cards', function(Blueprint $table) {
			$table->foreign('game_id')->references('id')->on('app_game')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game_opponent_graveyard_cards', function(Blueprint $table) {
			$table->foreign('card_id')->references('id')->on('app_card')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game_opponent_hand_cards', function(Blueprint $table) {
			$table->foreign('game_id')->references('id')->on('app_game')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game_opponent_hand_cards', function(Blueprint $table) {
			$table->foreign('card_id')->references('id')->on('app_card')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game_owner_board_values', function(Blueprint $table) {
			$table->foreign('game_id')->references('id')->on('app_game')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game_owner_board_values', function(Blueprint $table) {
			$table->foreign('cardvalued_id')->references('id')->on('app_card')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game_owner_deck_cards', function(Blueprint $table) {
			$table->foreign('game_id')->references('id')->on('app_game')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game_owner_deck_cards', function(Blueprint $table) {
			$table->foreign('card_id')->references('id')->on('app_card')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game_owner_graveyard_cards', function(Blueprint $table) {
			$table->foreign('game_id')->references('id')->on('app_game')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game_owner_graveyard_cards', function(Blueprint $table) {
			$table->foreign('card_id')->references('id')->on('app_card')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game_owner_hand_cards', function(Blueprint $table) {
			$table->foreign('game_id')->references('id')->on('app_game')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_game_owner_hand_cards', function(Blueprint $table) {
			$table->foreign('card_id')->references('id')->on('app_card')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_user_groups', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('app_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_user_groups', function(Blueprint $table) {
			$table->foreign('groupe_id')->references('id')->on('auth_group')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('auth_group_permissions', function(Blueprint $table) {
			$table->foreign('groupe_id')->references('id')->on('auth_group')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('auth_group_permissions', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('auth_permission')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_user_permission', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('app_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_user_permission', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('auth_permission')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('app_card', function(Blueprint $table) {
			$table->dropForeign('app_card_effect_id_foreign');
		});
		Schema::table('app_card_value', function(Blueprint $table) {
			$table->dropForeign('app_card_value_card_id_foreign');
		});
		Schema::table('app_card_value', function(Blueprint $table) {
			$table->dropForeign('app_card_value_user_foreign');
		});
		Schema::table('app_deck', function(Blueprint $table) {
			$table->dropForeign('app_deck_user_id_foreign');
		});
		Schema::table('app_deck_cards', function(Blueprint $table) {
			$table->dropForeign('app_deck_cards_deck_id_foreign');
		});
		Schema::table('app_deck_cards', function(Blueprint $table) {
			$table->dropForeign('app_deck_cards_card_id_foreign');
		});
		Schema::table('app_game', function(Blueprint $table) {
			$table->dropForeign('app_game_opponent_id_foreign');
		});
		Schema::table('app_game', function(Blueprint $table) {
			$table->dropForeign('app_game_opponent_deck_id_foreign');
		});
		Schema::table('app_game', function(Blueprint $table) {
			$table->dropForeign('app_game_owner_id_foreign');
		});
		Schema::table('app_game', function(Blueprint $table) {
			$table->dropForeign('app_game_owner_deck_id_foreign');
		});
		Schema::table('app_game', function(Blueprint $table) {
			$table->dropForeign('app_game_player_turn_id_foreign');
		});
		Schema::table('app_game', function(Blueprint $table) {
			$table->dropForeign('app_game_rule_id_foreign');
		});
		Schema::table('app_game_log', function(Blueprint $table) {
			$table->dropForeign('app_game_log_game_id_foreign');
		});
		Schema::table('app_game_log', function(Blueprint $table) {
			$table->dropForeign('app_game_log_looser_id_foreign');
		});
		Schema::table('app_game_log', function(Blueprint $table) {
			$table->dropForeign('app_game_log_winner_id_foreign');
		});
		Schema::table('app_game_log_action', function(Blueprint $table) {
			$table->dropForeign('app_game_log_action_game_log_id_foreign');
		});
		Schema::table('app_game_log_action', function(Blueprint $table) {
			$table->dropForeign('app_game_log_action_user_id_foreign');
		});
		Schema::table('app_game_opponnent_board_card_values', function(Blueprint $table) {
			$table->dropForeign('app_game_opponnent_board_card_values_game_id_foreign');
		});
		Schema::table('app_game_opponnent_board_card_values', function(Blueprint $table) {
			$table->dropForeign('app_game_opponnent_board_card_values_cardvalue_id_foreign');
		});
		Schema::table('app_game_opponent_deck_cards', function(Blueprint $table) {
			$table->dropForeign('app_game_opponent_deck_cards_game_id_foreign');
		});
		Schema::table('app_game_opponent_deck_cards', function(Blueprint $table) {
			$table->dropForeign('app_game_opponent_deck_cards_card_id_foreign');
		});
		Schema::table('app_game_opponent_graveyard_cards', function(Blueprint $table) {
			$table->dropForeign('app_game_opponent_graveyard_cards_game_id_foreign');
		});
		Schema::table('app_game_opponent_graveyard_cards', function(Blueprint $table) {
			$table->dropForeign('app_game_opponent_graveyard_cards_card_id_foreign');
		});
		Schema::table('app_game_opponent_hand_cards', function(Blueprint $table) {
			$table->dropForeign('app_game_opponent_hand_cards_game_id_foreign');
		});
		Schema::table('app_game_opponent_hand_cards', function(Blueprint $table) {
			$table->dropForeign('app_game_opponent_hand_cards_card_id_foreign');
		});
		Schema::table('app_game_owner_board_values', function(Blueprint $table) {
			$table->dropForeign('app_game_owner_board_values_game_id_foreign');
		});
		Schema::table('app_game_owner_board_values', function(Blueprint $table) {
			$table->dropForeign('app_game_owner_board_values_cardvalued_id_foreign');
		});
		Schema::table('app_game_owner_deck_cards', function(Blueprint $table) {
			$table->dropForeign('app_game_owner_deck_cards_game_id_foreign');
		});
		Schema::table('app_game_owner_deck_cards', function(Blueprint $table) {
			$table->dropForeign('app_game_owner_deck_cards_card_id_foreign');
		});
		Schema::table('app_game_owner_graveyard_cards', function(Blueprint $table) {
			$table->dropForeign('app_game_owner_graveyard_cards_game_id_foreign');
		});
		Schema::table('app_game_owner_graveyard_cards', function(Blueprint $table) {
			$table->dropForeign('app_game_owner_graveyard_cards_card_id_foreign');
		});
		Schema::table('app_game_owner_hand_cards', function(Blueprint $table) {
			$table->dropForeign('app_game_owner_hand_cards_game_id_foreign');
		});
		Schema::table('app_game_owner_hand_cards', function(Blueprint $table) {
			$table->dropForeign('app_game_owner_hand_cards_card_id_foreign');
		});
		Schema::table('app_user_groups', function(Blueprint $table) {
			$table->dropForeign('app_user_groups_user_id_foreign');
		});
		Schema::table('app_user_groups', function(Blueprint $table) {
			$table->dropForeign('app_user_groups_groupe_id_foreign');
		});
		Schema::table('auth_group_permissions', function(Blueprint $table) {
			$table->dropForeign('auth_group_permissions_groupe_id_foreign');
		});
		Schema::table('auth_group_permissions', function(Blueprint $table) {
			$table->dropForeign('auth_group_permissions_permission_id_foreign');
		});
		Schema::table('app_user_permission', function(Blueprint $table) {
			$table->dropForeign('app_user_permission_user_id_foreign');
		});
		Schema::table('app_user_permission', function(Blueprint $table) {
			$table->dropForeign('app_user_permission_permission_id_foreign');
		});
	}
}