<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppUserTable extends Migration {

	public function up()
	{
		Schema::create('app_user', function(Blueprint $table) {
			$table->increments('id');
			$table->string('password', 128);
			$table->datetime('last_login');
			$table->boolean('is_superuser');
			$table->string('username', 150);
			$table->string('first_name', 30);
			$table->string('last_name', 150);
			$table->string('email', 254);
			$table->boolean('is_staff');
			$table->boolean('is_active');
			$table->datetime('date_joined');
		});
	}

	public function down()
	{
		Schema::drop('app_user');
	}
}