<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('email', 255);
			$table->string('password', 255);
			$table->tinyInteger('block')->default('1');
			$table->enum('menu_type', array('"menu"', '"file"'))->nullable();
			$table->enum('user_type', array('"admin"', '"restaurant"'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}